///////////////////////////////////
// ********************************
// LENS-FLARE(S) 2013 by priest
//
// LENS-FLARE(S) 2020 - Translated in lite c  by Ayaka
//
// ****************************************************
///////////////////////////////////////////////////////

/*

Log:
Aktivierung durch einkommentieren des Defines "LfpActivateDebug".
Im Debugmodus werden Logs geschrieben und knnen im acklog.txt gelesen werden.

Initialisierung:
Aufruf der berladenen Funktion LfpInitialize.
Die Funktion liest Entitys bei Levelstart ein oder nimmt selbige entgegen, wenn
bereits eine Funktion existiert.

Start:
Aufruf der Funktion LfpStartLights.

Cleanup:
Aufruf der Funktion LfpCleanUp.
Die Lichter bereinigen sich auch selbst, wenn eine bestimmte Distanz berschritten wurde.

*/



// :: Pfade ::::::::::::::::::::::::::::::::::::::::::::::::::

#define PRAGMA_PATH "Code"
#define PRAGMA_PATH "Models"
#define PRAGMA_PATH "Images"
#define PRAGMA_PATH "shaders"

#define SSAO

// :: Includes :::::::::::::::::::::::::::::::::::::::::::::::

#include <litec.h>
#include <default.c>
#include <atypes.h>
#include <avars.h>

#include "ppSsao.h" 
#include "DebugHelper.c"
#include "CustomLensflares.c"






function main()
{
	camera.arc = 110;
	video_mode = 8;	 
	video_depth = 32; 
	video_screen=2;
	vec_set(sky_color, vector(0,0,0));
	warn_level= 6;

	random_seed(0);
	level_load("LensflareDemo.WMB");
	wait(1);
   //runSsao();
	
	LfpInitialize();
	LfpStartLights();

//	on_h = toggleSsaoState; 
//	LfpCleanUp();
}





//ENTITY* Sky =
//{
//  type = "envi_snow1+6.tga"; 
//  layer = 2;
//  u = 1.5;
//  v = -1.0;
//  flags2 = SKY | CUBE | SHOW;	
//} 
//

action VertexExample()
{
	my.flags |= PASSABLE;
	
	ENTITY* light = ent_create("sun.mdl", my.x, NULL);
	
	/* Calculate Size */
	light.LfpLightDist = 2300+ (my.scale_x * (abs(my.max_x) + abs(my.min_x)));

	light.parent = my;
	LfpAddLight(light, "LfpLTypePoint","LfpSun2", 6);
	
	while(1)
	{
		my.roll += 1 * time_step;
		DEBUG_VAR(vec_dist(light.x, camera.x),222);
		wait(1);
	}	
}

action Player()
{

	my.skill10 = my.z;
	my.flags |= INVISIBLE;
	
	while(me)	
	{
		my.pan -= 7 * mouse_force.x * time_step;
		my.tilt += 7 * mouse_force.y * time_step;
		
		vec_set(camera.x, vector(my.x, my.y, my.z+50));

		camera.pan = my.pan;
		camera.tilt = my.tilt;
		
		my.z = my.skill10;
		my.skill10 += 50 * (mouse_left - mouse_right) * time_step; 	
		my.tilt = clamp(my.tilt,-90,90); 
		my.skill1 = 25 * (key_w - key_s)*time_step; 
		my.skill2 = -10 * (key_d - key_a)*time_step;
		
		c_move(me, my.skill1, nullvector, GLIDE | IGNORE_ME | IGNORE_SPRITES);
		
		wait(1);   
	}
}

action Statue()
{
	c_move(my, nullvector, nullvector, NULL);
}

///
// Trigger zum auslsen von diversen Events (i.e. Sonne)
#define MaxX skill1
#define MinX skill2
#define MaxY skill3
#define MinY skill4
#define IsRadius FLAG5
#define MoveX FLAG1
#define MoveY FLAG2
action LfpEventTrigger()
{
	return;
//	my.flags |= PASSABLE|INVISIBLE;
//	
//	while(me)	
//	{		
//		my.z = camera.z;
//		
//		if (!is(my, IsRadius))
//		{
//			if (camera.x < my.MaxX && camera.x > my.MinX && is(my, MoveX)) 
//			{
//				my.x = camera.x;
//			}
//			
//			if (camera.y < my.MaxY && camera.y > my.MinY && is(my, MoveY)) 
//			{
//				my.y = camera.y;
//			}
//			
//			if (vec_dist(my.x, camera.x) < 25)
//			{
//				Lfp.TriggerId = my.skill20;
//			}
//		}
//		else
//		{
//			if (vec_dist(my.x, camera.x) < my.MaxX) 
//			{
//				Lfp.TriggerId = my.skill20;
//			}
//		}
//		
//
//		switch(Lfp.TriggerId)
//		{
//			case 1:
//			Lfp.SunActive = true;
//			Lfp.TriggerId = 0;
//			break;
//			
//			case 2:
//			Lfp.SunActive = false;
//			Lfp.TriggerId = 0;				
//			break;
//		}
//		
//		//		if (camera.arc > 119) {my.skill30 = (camera.arc-110)*2; Lfp.CameraArc = camera.arc - my.skill30;}
//		//		if (camera.arc < 100) {my.skill30 = (110-camera.arc)*2; Lfp.CameraArc = camera.arc + my.skill30;}
//		//		
//		wait(1);
//	}
}





